(function($) {
    Drupal.behaviors.projectsmapMap = {
        attach: function (context, settings) {

            var overlay;
            var map = null;
            var marker = null;
            OldCityOverlay.prototype = new google.maps.OverlayView();

            function initMap() {
                map = new google.maps.Map(document.getElementById('map'), {
                    zoom: 16,
                    center: {lat: 31.778261, lng: 35.2316125},
                    mapTypeId: 'satellite'
                });

                var bounds = new google.maps.LatLngBounds(
                    new google.maps.LatLng(31.77278, 35.225652),
                    new google.maps.LatLng(31.783742, 35.237573));

                var pathToTheme = Drupal.settings.pathToTheme;
                var srcImage = pathToTheme + '/images/basemap.png';

                // The custom OldCityOverlay object contains the overlay image,
                // the bounds of the image, and a reference to the map.

                overlay = new OldCityOverlay(bounds, srcImage, map);

                var infoWindow = new google.maps.InfoWindow;
                map.data.loadGeoJson('http://ocjrp.beyondesigns.net/data/geojson/ourprojects2');
                // global infowindow
                infoWindow = new google.maps.InfoWindow({
                    content: ""
                });

                // When the user clicks, open an infowindow
                map.data.addListener('click', function (event) {
                    //show an infowindow on click
                    infoWindow.setContent('<div style="line-height:1.35;overflow:hidden;white-space:nowrap;"> ' + event.feature.getProperty("title") + "</div>");
                    var anchor = new google.maps.MVCObject();
                    anchor.set("position", event.latLng);
                    infoWindow.open(map, anchor);
                });

                map.data.setStyle(function (feature) {
                    var color = 'gray';
                    if (feature.getProperty('isColorful')) {
                        color = feature.getProperty('color');
                        color = 'red';
                    }
                    return /** @type {google.maps.Data.StyleOptions} */({
                        fillColor: color,
                        strokeColor: color,
                        strokeWeight: 2
                    });
                });


                // Change this depending on the name of your PHP or XML file
                //downloadUrl('https://storage.googleapis.com/mapsdevsite/json/mapmarkers2.xml', function(data) {

                //});


            }

            /* $("body").click(function() {
                 map.data.forEach(function (feature) {
                     if(feature.getProperty("ukey")==901516){
                         feature.setProperty('isColorful', true);
                     }
                 });
             })*/

            function downloadUrl(url, callback) {
                var request = window.ActiveXObject ?
                    new ActiveXObject('Microsoft.XMLHTTP') :
                    new XMLHttpRequest;

                request.onreadystatechange = function () {
                    if (request.readyState == 4) {
                        request.onreadystatechange = doNothing;
                        callback(request, request.status);
                    }
                };

                request.open('GET', url, true);
                request.send(null);
            }


            // Change this depending on the name of your PHP or XML file


            /** @constructor */
            function OldCityOverlay(bounds, image, map) {

                // Initialize all properties.
                this.bounds_ = bounds;
                this.image_ = image;
                this.map_ = map;

                // Define a property to hold the image's div. We'll
                // actually create this div upon receipt of the onAdd()
                // method so we'll leave it null for now.
                this.div_ = null;

                // Explicitly call setMap on this overlay.
                this.setMap(map);
            }

            /**
             * onAdd is called when the map's panes are ready and the overlay has been
             * added to the map.
             */
            OldCityOverlay.prototype.onAdd = function () {

                var div = document.createElement('div');
                div.style.borderStyle = 'none';
                div.style.borderWidth = '0px';
                div.style.position = 'absolute';

                // Create the img element and attach it to the div.
                var img = document.createElement('img');
                img.src = this.image_;
                img.style.width = '100%';
                img.style.height = '100%';
                img.style.position = 'absolute';
                div.appendChild(img);

                this.div_ = div;

                // Add the element to the "overlayLayer" pane.
                var panes = this.getPanes();
                panes.overlayLayer.appendChild(div);
            };

            OldCityOverlay.prototype.draw = function () {

                // We use the south-west and north-east
                // coordinates of the overlay to peg it to the correct position and size.
                // To do this, we need to retrieve the projection from the overlay.
                var overlayProjection = this.getProjection();

                // Retrieve the south-west and north-east coordinates of this overlay
                // in LatLngs and convert them to pixel coordinates.
                // We'll use these coordinates to resize the div.
                var sw = overlayProjection.fromLatLngToDivPixel(this.bounds_.getSouthWest());
                var ne = overlayProjection.fromLatLngToDivPixel(this.bounds_.getNorthEast());

                // Resize the image's div to fit the indicated dimensions.
                var div = this.div_;
                div.style.left = sw.x + 'px';
                div.style.top = ne.y + 'px';
                div.style.width = (ne.x - sw.x) + 'px';
                div.style.height = (sw.y - ne.y) + 'px';
            };

            // The onRemove() method will be called automatically from the API if
            // we ever set the overlay's map property to 'null'.
            OldCityOverlay.prototype.onRemove = function () {
                this.div_.parentNode.removeChild(this.div_);
                this.div_ = null;
            };


            function doNothing() {
            }

            $('.block-map .show-map a').click(function () {
                console.log('clicked to be open');
                $('.block-map').addClass('opened').removeClass('closed').delay(800).promise().done(function () {
                    if ($('#map').is(':empty')) {
                        initMap();
                    }
                });
            });

            $('.block-map .close-map a').click(function () {
                console.log('clicked to be closed');
                $('.block-map').addClass('closed');
                $('.block-map').removeClass('opened');
            });

            //this code is for the portion that shows and hides the projects

            $('.view-all-projects-categories-terms a.terms_classes').click(function (e) {
                e.preventDefault();
                var $old_id = 0;
                if ($('view-all-projects-categories-terms a.selected').length) {
                    $old_id = $('view-all-projects-categories-terms a.selected').attr('id');
                }
                var $category_with_id = $(this).attr('id');
                if ($old_id !== $category_with_id) {
                    var $category_with_id_array = $category_with_id.split('_');

                    var $category_id = $category_with_id_array[1];
                    $('.view-restoration-project-list .termid').closest('.views-row').removeClass('show');
                    $('.view-restoration-project-list .termid').closest('.views-row').addClass('hide');
                    var $results = $('.view-restoration-project-list').find('.termid').filter(function () {
                        return $(this).text() === $category_id;
                    }).parent();
                    $results.closest('.views-row').removeClass('hide');
                    $results.closest('.views-row').addClass('show');
                    $(this).addClass('selected');
                }
                return false;
            });

             $('.view-restoration-project-list a.project-title').click(function(e) {
                 e.preventDefault();
                 var $ukey=$(this).closest('.views-row').find('.ukey').text();
                 var bounds = new google.maps.LatLngBounds();
                 map.data.forEach(function (feature) {
                     if(feature.getProperty('ukey')==$ukey){
                         feature.setProperty('isColorful', true);
                         feature.getGeometry().forEachLatLng(function(latlng){
                             bounds.extend(latlng);
                         });
                     }
                 });
                 map.fitBounds(bounds);
                 return false;
             });
        }
    };
}(jQuery));
;
window.CKEDITOR_BASEPATH = '/sites/all/libraries/ckeditor/';;
