<?php

/**
 * @file
 * Template overrides as well as (pre-)process and alter hooks for the
 * Beyond Designs theme.
 */

function beyond_designs_preprocess_html(&$variables) {
    if (!empty($variables['page']['sidebar_first']) && !empty($variables['page']['sidebar_second'])) {
        $variables['classes_array'][] = 'two_sidebars';
    }
    elseif (!empty($variables['page']['sidebar_first'])) {
        $variables['classes_array'][] = 'one_sidebar sidebar_first';
    }
    elseif (!empty($variables['page']['sidebar_second'])) {
        $variables['classes_array'][] = 'one_sidebar sidebar_second';
    }
    else {
        $variables['classes_array'][] = 'no_sidebars';
    }
}


/*** Social menu alter
 *
 *
function beyond_designs_menu_link(array $variables) {
    $element  = $variables['element'];
    $menuName = $variables['element']["#original_link"]["menu_name"];
    $sub_menu = '';
    $new_item = '';
    $search_icon = '';

    if ($element['#below']) {
        $sub_menu = drupal_render($element['#below']);
    }

    $output = l($element['#title'], $element['#href'], $element['#localized_options']);



    //$lang_block =(module_invoke( 'admin_language', 'block_view', 'admin_language_switcher'));
    $lang_block =(module_invoke( 'locale', 'block_view', 'language'));
    //$lang_block =(module_invoke( 'locale', 'block_view', 'language_content'));

    if ($menuName == "menu-social-menu" && in_array("last",$element['#attributes']['class'])) {
        $new_item = '<li class="lang-item lang--">'. render($lang_block['content']) . '</li>';
        $search_icon = '<span class="sep"></span> <li class="search-li"><a class="search-icon"></a></li>';
        $finalString = '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>";
    }
    else {
        $finalString = '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>";
    }

    return $finalString.$new_item.$search_icon;
}
*/

/**
 * Implements hook_language_switch_links_alter().
 */
function beyond_designs_language_switch_links_alter(&$links, $type, $path) {
    global $language;
    /*
    if ($type == LANGUAGE_TYPE_INTERFACE && isset($links[$language->language])) {
        foreach ($links as $langcode => &$link) {
            $link['href'] = '<front>';
        }
    }
    */
}