/**
 * @file
 * A JavaScript file for the theme.
 *
 * In order for this JavaScript to be loaded on pages, see the instructions in
 * the README.txt next to this file.
 */

// JavaScript should be made compatible with libraries other than jQuery by
// wrapping it with an "anonymous closure". See:
// - https://drupal.org/node/1446420
// - http://www.adequatelygood.com/2010/3/JavaScript-Module-Pattern-In-Depth
(function ($, Drupal, window, document, undefined) {

    /*******************************************************/
    /*******Birzeit Website Script file***********/
    /*******************************************************/

// To understand behaviors, see https://drupal.org/node/756722#behaviors
    Drupal.behaviors.my_custom_behavior = {
        attach: function(context, settings) {

            // Touch Device Detection
            var isTouchDevice = 'ontouchstart' in document.documentElement;
            if( isTouchDevice ) {
                $('body').addClass('is-touch-device');
            }

            //Adds "All" to letter of index a-z
            var lang = $('html').attr('lang');
            if (lang == 'en'){
                $('.view-index-a-z ul.views-summary li:last').after('<li class="all"><a href="'+Drupal.settings.basePath+'site-a-z">'+Drupal.t('All')+'</a></li>');
                $('.view-academic-departments-a-z ul.views-summary li:last').after('<li class="all"><a href="'+Drupal.settings.basePath+'study/academic-departments">'+Drupal.t('All')+'</a></li>');
            }
            else {
                $('.view-index-a-z ul.views-summary li:last').after('<li class="all"><a href="'+Drupal.settings.basePath+ lang+'/site-a-z">'+Drupal.t('All')+'</a></li>');
                $('.view-academic-departments-a-z ul.views-summary li:last').after('<li class="all"><a href="'+Drupal.settings.basePath+ lang+'/study/academic-departments">'+Drupal.t('All')+'</a></li>');
            }

            //Search lens
            $('.tcon-search--xcross', context).click(function(){
                $('#search-drawer').slideToggle(700, 'easeOutBack').toggleClass('open');
                $('#search-icon').toggleClass('active');
                $('#search-drawer.open input#edit-search-block-form--2').focus();
                $('#top-bar .diamond').toggle();
            });

            //SiteMap plus icon
            $('#sitemap-icon', context).click(function(){
                $('#block-footer-sitemap-footer-sitemap').slideToggle(500);
                $('#sitemap-icon .plus').toggleClass('open');

            });

            //A-Z letters, add active class
            $('.view-index-a-z ul.views-summary li a').click(function(){
                $(this).toggleClass('active');
            });

            //Ajax load container
            //$('#content', context).once().after('<div class="ajax-content">');

            $('.toggle-link').click(function(){
                $(this).next().slideToggle(300);
                //$('.mobile-nav-button .icon-cancel, .mobile-nav-button .icon-menu').toggle();
                $(this).parent().toggleClass('active');
            });

            $('.tcon-menu--xbutterfly').click(function(){
                $('#mobile-nav').slideToggle(500);
                $('#mobile-nav').toggleClass('open');
                $('.mobile-nav-button .icon-cancel, .mobile-nav-button .icon-menu').toggle();
                $(this).toggleClass('active');
            });

            $('form#views-exposed-form-news-page input#edit-combine').attr('placeholder', Drupal.t('Search news'));
            $('div#block-views-exp-blog-archive-page-1 input#edit-combine').attr('placeholder', Drupal.t('Search blog posts'));

            $('#mobile-nav li.is-expanded').append('<div class="arrow"><i class="font-icon icon-angle-down"></i></div>');

            $('#mobile-nav .arrow').click(function(){
                $(this).parent('li').toggleClass('opened');
                $(this).parent('li.is-expanded').find('ul.menu').slideToggle(200);
            });

            $(window).resize(function(){

                if ($(window).width() >= 870 && $('.tcon-menu--xbutterfly').hasClass('active')) {
                    $('#mobile-nav').toggleClass('open').css('display', 'none');
                    $('.tcon-menu--xbutterfly').removeClass('active');
                    $('.tcon-menu--xbutterfly').removeClass('tcon-transform');
                }
            });

            $('.full-box').readmore({
                speed: 175,
                collapsedHeight: 110,
                moreLink: '<a class="more-less" href="#"><i class="icon-down-open"></i></a>',
                lessLink: '<a class="more-less" href="#"><i class="icon-up-open"></i></a>'
            });

            //Make divs equal hight
            $('.content-2, .content-3').matchHeight();

            //Modal Window > 480
            if ($(window).width() > 480){
                $('.modal-btn').click(function(){
                    $(this).next('.modal').css({
                        "opacity": "1",
                        "z-index": "100"
                    });
                });

                $('.modal-close, .modal-cancel').click(function(){
                    $(this).closest('.modal').css({
                        "opacity": "0",
                        "z-index": "-100"
                    });
                });
            }

            //Modal window on Moble <= 480
            if ($(window).width() <= 480) {
                $('.modal').slideUp();
                $('.modal-btn').click(function(){
                    $(this).next('.modal').slideToggle();
                });

                $('.modal-close, .modal-cancel').click(function(){
                    $(this).closest('.modal').slideUp();
                });
            }

            //Update selected options label, Faculty members modal
            //$('#edit-field-parent-business-unit-id-target-id-wrapper label').after('<span class="label">');
            $('#edit-field-parent-business-unit-id-target-id').change(function() {
                //$('.label').text($('ok'));
                //$(this).closest('.view-container').css('border', '1px solid red');
            });

            $('#edit-field-parent-business-unit-id-target-id-wrapper label', context).click(function(){
                $(this).next().toggle();
                $(this).parent().next().toggle();
            });

            //Hide Alert if is collapsed.
            if(getCookie("AlertState")!= 'undefined' && getCookie("AlertState") == 'hidden') {
                $('#alert').hide();
                $('.pull-btn').toggleClass('closed');
            }

            $('.pull-btn', context).click(function(){
                $(this).toggleClass('closed');
                $('#alert').slideToggle(700, 'easeOutBack', function(){
                    if($("#alert").is(":visible"))
                        setCookie("AlertState", 'visible',5);
                    else
                        setCookie("AlertState", 'hidden',5);

                    console.log(getCookie("AlertState"));
                });


                $(this).blur();

            });

            /*
             //Masonry

             $(window).load(function(){
             var e = $('#block-views-multimedia-block-4 .view-content');

             e.isotope({
             // options
             itemSelector: '.grid-item',
             masonry: {
             columnWidth: 208,
             gutter: 10,
             fitWidth: true,
             }
             });
             });
             */

            /*
             $( ".view-get-faculties .faculty-box" ).each(function() {
             var attr = $(this).attr('data-background-image');

             if (typeof attr !== typeof undefined && attr !== false) {
             $(this).css('background-image', 'url('+attr+')');
             }

             });
             $( ".view-get-faculties .faculty-box .faculty-name" ).each(function() {
             var attr = $(this).attr('data-color');

             if (typeof attr !== typeof undefined && attr !== false) {
             $(this).css('background-color', attr);
             }

             });

             jQuery('').css('background-image', jQuery(this).attr('data-background-image'));
             */

//Return frontpage photo gallery number of photos
            var photoNum;
            photoNum = $('.view-fp-multimedia-photo-gallery .views-row a').length;
            $('.view-fp-multimedia-photo-gallery .photo-count .count').text(photoNum);



        }
    };

    function setCookie(c_name, value, exdays) {
        var exdate = new Date();
        exdate.setDate(exdate.getDate() + exdays);
        var c_value = escape(value) + ((exdays == null) ? "" : "; expires=" + exdate.toUTCString());
        document.cookie = c_name + "=" + c_value;
    }

    function getCookie(c_name) {
        var i, x, y, ARRcookies = document.cookie.split(";");
        for (i = 0; i < ARRcookies.length; i++) {
            x = ARRcookies[i].substr(0, ARRcookies[i].indexOf("="));
            y = ARRcookies[i].substr(ARRcookies[i].indexOf("=") + 1);
            x = x.replace(/^\s+|\s+$/g, "");
            if (x == c_name) {
                return unescape(y);
            }
        }
    }


})(jQuery, Drupal, this, this.document);

// Transform Icons
!function(n,r){"function"==typeof define&&define.amd?define(r):"object"==typeof exports?module.exports=r():n.transformicons=r()}(this||window,function(){"use strict";var n={},r="tcon-transform",t={transform:["click"],revert:["click"]},e=function(n){return"string"==typeof n?Array.prototype.slice.call(document.querySelectorAll(n)):"undefined"==typeof n||n instanceof Array?n:[n]},o=function(n){return"string"==typeof n?n.toLowerCase().split(" "):n},f=function(n,r,f){var c=(f?"remove":"add")+"EventListener",u=e(n),s=u.length,a={};for(var l in t)a[l]=r&&r[l]?o(r[l]):t[l];for(;s--;)for(var d in a)for(var v=a[d].length;v--;)u[s][c](a[d][v],i)},i=function(r){n.toggle(r.currentTarget)};return n.add=function(r,t){return f(r,t),n},n.remove=function(r,t){return f(r,t,!0),n},n.transform=function(t){return e(t).forEach(function(n){n.classList.add(r)}),n},n.revert=function(t){return e(t).forEach(function(n){n.classList.remove(r)}),n},n.toggle=function(t){return e(t).forEach(function(t){n[t.classList.contains(r)?"revert":"transform"](t)}),n},n});